/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.dataconnect.MethodFactory;
import com.belenus.dataconnect.ParameterContainer;
import com.belenus.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Template {
    private static MethodFactory s_methodFactory = new MethodFactory();
    private String m_templateString;
    private ParameterContainer m_parameterContainer;
    private ArrayList m_methods;
    private ArrayList m_parameterArrays;

    public Template(String templateString, ParameterContainer parameterContainer) {
        if (templateString == null) {
            throw new IllegalArgumentException("Query template not found (is null)!");
        }
        this.m_templateString = templateString;
        this.m_parameterContainer = parameterContainer;
    }

    public String getTemplateString() {
        return this.m_templateString;
    }

    public ParameterContainer getParameterContainer() {
        return this.m_parameterContainer;
    }

    private String useMethod(String methodParameter, boolean usePreparedStatement) {
        int colonPosition = methodParameter.indexOf(58);
        if (colonPosition >= 0) {
            String methodName = methodParameter.substring(0, colonPosition);
            String parametersString = methodParameter.substring(colonPosition + 1);
            String[] parameters = StringUtil.split(parametersString, ",");
            Object[] resultVariables = new Object[parameters.length];
            for (int parametersIndex = 0; parametersIndex < parameters.length; ++parametersIndex) {
                String parameter = parameters[parametersIndex];
                resultVariables[parametersIndex] = this.m_parameterContainer.getParameter(parameter.trim());
            }
            MethodFactory.Method method = s_methodFactory.create(methodName, resultVariables);
            if (usePreparedStatement) {
                this.m_methods.add(method);
                this.m_parameterArrays.add(resultVariables);
                return method.preparePreparedStatement(resultVariables);
            }
            return method.applyDirectly(resultVariables);
        }
        throw new RuntimeException("Invalid parameter: " + methodParameter);
    }

    private String applyTemplate(boolean usePreparedStatement) {
        if (this.m_templateString.indexOf("{") == -1) {
            return this.m_templateString;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_templateString, "", false);
        StringBuffer filledTemplate = new StringBuffer();
        do {
            String staticToken;
            if ((staticToken = stringTokenizer.nextToken("{")).startsWith("}")) {
                staticToken = staticToken.substring(1);
            }
            filledTemplate.append(staticToken);
            if (!stringTokenizer.hasMoreTokens()) break;
            String dynamicToken = stringTokenizer.nextToken("}");
            if (dynamicToken.startsWith("{")) {
                dynamicToken = dynamicToken.substring(1);
            }
            filledTemplate.append(this.useMethod(dynamicToken, usePreparedStatement));
        } while (stringTokenizer.hasMoreTokens());
        return filledTemplate.toString();
    }

    public String fill() {
        return this.applyTemplate(false);
    }

    public PreparedStatement fill(Connection connection) throws SQLException {
        this.m_methods = new ArrayList();
        this.m_parameterArrays = new ArrayList();
        String filledTemplate = this.applyTemplate(true);
        PreparedStatement preparedStatement = connection.prepareStatement(filledTemplate);
        int parameterIndex = 1;
        for (int methodsIndex = 0; methodsIndex < this.m_methods.size(); ++methodsIndex) {
            Object[] resultVariables = (Object[])this.m_parameterArrays.get(methodsIndex);
            MethodFactory.Method method = (MethodFactory.Method)this.m_methods.get(methodsIndex);
            parameterIndex = method.applyPreparedStatement(preparedStatement, parameterIndex, resultVariables);
        }
        return preparedStatement;
    }
}

